# 实现 Trie (前缀树)

<p><strong><a href="https://baike.baidu.com/item/字典树/9825209?fr=aladdin" target="_blank">Trie</a></strong>（发音类似 "try"）或者说 <strong>前缀树</strong> 是一种树形数据结构，用于高效地存储和检索字符串数据集中的键。这一数据结构有相当多的应用情景，例如自动补完和拼写检查。</p>

<p>请你实现 Trie 类：</p>

<ul>
	<li><code>Trie()</code> 初始化前缀树对象。</li>
	<li><code>void insert(String word)</code> 向前缀树中插入字符串 <code>word</code> 。</li>
	<li><code>boolean search(String word)</code> 如果字符串 <code>word</code> 在前缀树中，返回 <code>true</code>（即，在检索之前已经插入）；否则，返回 <code>false</code> 。</li>
	<li><code>boolean startsWith(String prefix)</code> 如果之前已经插入的字符串 <code>word</code> 的前缀之一为 <code>prefix</code> ，返回 <code>true</code> ；否则，返回 <code>false</code> 。</li>
</ul>

<p> </p>

<p><strong>示例：</strong></p>

<pre>
<strong>输入</strong>
["Trie", "insert", "search", "search", "startsWith", "insert", "search"]
[[], ["apple"], ["apple"], ["app"], ["app"], ["app"], ["app"]]
<strong>输出</strong>
[null, null, true, false, true, null, true]

<strong>解释</strong>
Trie trie = new Trie();
trie.insert("apple");
trie.search("apple");   // 返回 True
trie.search("app");     // 返回 False
trie.startsWith("app"); // 返回 True
trie.insert("app");
trie.search("app");     // 返回 True
</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= word.length, prefix.length <= 2000</code></li>
	<li><code>word</code> 和 <code>prefix</code> 仅由小写英文字母组成</li>
	<li><code>insert</code>、<code>search</code> 和 <code>startsWith</code> 调用次数 <strong>总计</strong> 不超过 <code>3 * 10<sup>4</sup></code> 次</li>
</ul>

<p>以下错误的选项是？</p>

## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp

```

## 答案
```cpp
class TrieNode
{
public:
    bool end_with;
    TrieNode *next[26];

    TrieNode()
    {
        end_with = false;
        memset(next, 0, sizeof(next));
    }
};

class Trie
{
    TrieNode root;

public:
    /** Initialize your data structure here. */
    Trie() {}

    /** Inserts a word into the trie. */
    void insert(string word)
    {
        TrieNode *node = &root;
        for (int i = 0; i < word.size(); i++)
        {
            int c = word[i] - 'a';
            node->next[c] = new TrieNode();
            node = node->next[c];
        }
        node->end_with = true;
    }

    /** Returns if the word is in the trie. */
    bool search(string word)
    {
        TrieNode *node = &root;
        for (int i = 0; i < word.size(); i++)
        {
            if (node->next[word[i] - 'a'] != NULL)
                node = node->next[word[i] - 'a'];
            else
                return false;
        }
        return (node->end_with) ? true : false;
    }

    /** Returns if there is any word in the trie that starts with the given prefix. */
    bool startsWith(string prefix)
    {
        TrieNode *node = &root;
        for (int i = 0; i < prefix.size(); i++)
        {
            if (node->next[prefix[i] - 'a'] != NULL)
                node = node->next[prefix[i] - 'a'];
            else
                return false;
        }
        return true;
    }
};
```
## 选项

### A
```cpp
struct TrieNode
{
    bool isEnd = false;
    TrieNode *children[26] = {NULL};
};

class Trie
{
public:
    Trie() : root(new TrieNode) {}

    void insert(string word)
    {
        TrieNode *p = root;
        for (int i = 0; i < word.size(); ++i)
        {
            int idx = word[i] - 'a';
            if (p->children[idx] == NULL)
                p->children[idx] = new TrieNode;
            p = p->children[idx];
        }
        p->isEnd = true;
    }

    bool search(string word)
    {
        auto p = root;
        for (int i = 0; i < word.size(); ++i)
        {
            int idx = word[i] - 'a';
            if (p->children[idx] == NULL)
                return false;
            p = p->children[idx];
        }
        return p->isEnd;
    }

    bool startsWith(string prefix)
    {
        auto p = root;
        for (int i = 0; i < prefix.size(); ++i)
        {
            int idx = prefix[i] - 'a';
            if (p->children[idx] == NULL)
                return false;
            p = p->children[idx];
        }
        return true;
    }

private:
    TrieNode *root;
};
```

### B
```cpp
struct TrieNode
{
    const static int MaxBranchNum = 26;
    char data;
    bool isEnd = false;
    vector<TrieNode *> children = vector<TrieNode *>(26);
    TrieNode(char data) : data(data){};
};

class Trie
{
public:
    Trie() : root(new TrieNode('/')) {}

    void insert(string word)
    {
        TrieNode *p = root;
        for (int i = 0; i < word.size(); ++i)
        {
            int idx = word[i] - 'a';
            if (p->children[idx] == NULL)
                p->children[idx] = new TrieNode(word[i]);
            p = p->children[idx];
        }
        p->isEnd = true;
    }

    bool search(string word)
    {
        auto p = root;
        for (int i = 0; i < word.size(); ++i)
        {
            int idx = word[i] - 'a';
            if (p->children[idx] == NULL)
                return false;
            p = p->children[idx];
        }
        return p->isEnd;
    }

    bool startsWith(string prefix)
    {
        auto p = root;
        for (int i = 0; i < prefix.size(); ++i)
        {
            int idx = prefix[i] - 'a';
            if (p->children[idx] == NULL)
                return false;
            p = p->children[idx];
        }
        return true;
    }

private:
    TrieNode *root;
};
```

### C
```cpp
struct Node
{
    map<char, Node *> next;
    bool f = false;  
};
class Trie
{
public:
    Node *head;
    /** Initialize your data structure here. */
    Trie()
    {
        head = new Node();
    }

    /** Inserts a word into the trie. */
    void insert(string word)
    {
        Node *t = head;
        for (char c : word)
        {
            if (t->next[c] == NULL)
            {
                Node *n = new Node;
                t->next[c] = n;
            }
            t = t->next[c];
        }
        t->f = true;
    }

    /** Returns if the word is in the trie. */
    bool search(string word)
    {
        Node *t = head;
        for (char c : word)
        {
            if (t->next[c] == NULL)
            {
                return false;
            }
            t = t->next[c];
        }
        return t->f;
    }

    /** Returns if there is any word in the trie that starts with the given prefix. */
    bool startsWith(string prefix)
    {
        Node *t = head;
        for (char c : prefix)
        {
            if (t->next[c] == NULL)
            {
                return false;
            }
            t = t->next[c];
        }
        return true;
    }
};
```
